package gov.va.med.mhv.usermgmt.data.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Version;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;
import gov.va.med.mhv.common.data.model.UserProfile;

@Entity
@Table(name = "EAUTHHASH")
public class EauthHash extends AbstractBaseEntity {

	private static final long serialVersionUID = -3213140274515205894L;

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	@Column(name = "EAUTHHASH_ID")
	private Long id;

	@Column(name = "HASH_VALUE")
	private String hashValue;

	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;

	@ManyToOne
	@JoinColumn(name = "USER_PROFILE_USER_PROFILE_ID")
	private UserProfile userProfile;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getHashValue() {
		return hashValue;
	}

	public void setHashValue(String hashValue) {
		this.hashValue = hashValue;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

}
